<?php $__env->startSection('content'); ?>

<div class="row">

   <div class="col-md-12" itemscope itemtype="http://schema.org/MobileApplication">
      <div class="block block-themed">
        <div class="block-header bg-light">
            <h3 class="block-title"><a href="<?php echo e(url('/')); ?>"><?php echo e(__('dcm.home')); ?></a> <?php echo e(__('dcm.breadcrumb_divider')); ?> <?php echo e(__('dcm.home_latest_featured_title',['attr' => $featured_app->title])); ?> </h3>
        </div>

        <div class="block-content px-0 pt-0" >
            <div class="content 3" itemprop="description" id="app_description">
                <?php echo nl2br( trim(@$featured_app->description)); ?>

            </div>
        </div>
        <div class="block-content block-content-full">

            <div class="row">
                <?php $__currentLoopData = $apps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-12 col-sm-12 col-md-2 mb-5 app-image text-center">
                        <img src="<?php echo e($app->app_image_url); ?>" alt="<?php echo e($app->title); ?>"
                            style="padding: 2px;background: #f7f7f7;border-radius: 10px;width:80px;">
                    </div>
                    <div class="col-12 col-sm-12 col-md-10 mb-5 mt-1" style="padding: 0 25px;">
                        <div>
                            <h4><?php echo e($app->title); ?></h4>
                        </div>

                        <div>
                            <div class="rating" itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating">
                                <div class="stars-detail">
                                <span class="score" title="<?php echo e($app->title); ?> average rating <?php echo e($app->current_ratings); ?>" style="width: <?php echo e(ceil(((double) $app->current_ratings / 5) * 100)); ?>%;"></span>
                                </div>
                                <meta itemprop="ratingCount" content="<?php echo e($app->current_ratings); ?>">
                                <meta itemprop="bestRating" content="5">
                                <meta itemprop="worstRating" content="1">
                            </div>
                            <span class="star average" itemprop="ratingValue"><?php echo e($app->current_ratings); ?></span>
                            <span class="details-delimiter"> | </span>
                                <a href="<?php echo e($app->app_detail_url); ?>" title="<?php echo e($app->title); ?> class="details-to-bottom" data-type="reviews"><?php echo e(__('dcm.total_reviews', ['attr' => 0])); ?></a>
                            <span class="details-delimiter"> | </span>
                                <a href="<?php echo e($app->app_detail_url); ?>"  class="details-to-bottom" data-type="posts"><?php echo e(__('dcm.total_comments', ['attr' => $app->comments->count()])); ?></a>
                        </div>

                        <div itemprop="description" id="app_description">
                                <?php echo str_limit(strip_tags(@$app->description), 150); ?>

                        </div>

                        <div class="mt-3">
                            <div class="btn-group mr-2 mb-2" role="group" aria-label="Icons File group">
                                <a href="<?php echo e($app->app_download_url); ?>" class="btn btn-success  btn-sm mr-1 mb-3">
                                    <i class="fa fa-fw fa-download mr-1"></i> <?php echo e(__('dcm.download_apk_title')); ?>

                                </a>
                                <a href="<?php echo e($app->app_detail_url); ?>" title="<?php echo e($app->title); ?>" class="btn btn-dark  btn-sm mr-1 mb-3">
                                    <i class="fa fa-fw fa-download mr-1"></i> <?php echo e(__('dcm.read_more')); ?>

                                </a>
                            </div>

                        </div>

                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="block-content block-content-full bg-body-light">
                <?php echo $apps->render(); ?>

            </div>
        </div>
      </div>

   </div>

</div>




<?php $__env->stopSection(); ?>


<?php $__env->startPush('javascript'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make( "layouts.master", \Illuminate\Support\Arr::except(get_defined_vars(), array('__data', '__path')))->render(); ?>